function [Nval] = NValue(tsample,Edge, Etri, Boundary, Vmem, Vnodal, Enodal, Nodal, Nodal_Bud, Nodes, Ntri, Nmem, vert)
%For time varying Neumann, first f what sampling.
%   This is an internal script for use in FEM_Solver_Parabolic_Neumann_Time
%   but when it comes to choose a different Neumann function, you specify
%   that here.

f = @(x,y,t) 1*(t<=.3); %Here where input the Neumann function

%From the f and tsample, extract the Neumann data at Nodes
Ndata = arrayfun(@(x,y) f(x,y,tsample), Nodes(:,1),Nodes(:,2));

for i=1:size(Ndata,1)      %So no artifical difficulty, scan the nodal vector
    if  Ndata(i,1) == Inf  %for Neumann data, if an Inf or undefined, replace 
        Ndata(i,1) = 0;    %it with a 0.  So long as this function is truly 
    elseif isnan(Ndata(i,1)) == 1  %defined on the boundary, this won't
        Ndata(i,1) = 0;    %affect the computations.
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Integrate Neumann Data %%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Unlike the steady state neumann, now we're allowing variable time
%possibilities.
Nval = zeros(Nodal_Bud(4,1),1); %Is the forcing term column vector
[W, Points] = Weights_1D(1);

for i=Nodal_Bud(2,1)+1:Nodal_Bud(3,1)
                                        %These are boundary nodes at
                                        %start/stop to boundary edges.
                                        %Hence, each belongs to two edges.
    E = zeros(1,2); %For storing membership edges this varphi_i. 
    c = 0; %counter
    for r=1:size(Boundary,1) %cycle through all boundary edges.
        for s = 3:4 %go to vertices contained by that edge
            if Nodal(i,1) == Boundary(r,s) %Check to see if our boundary node 
                                           %has been found belonging to an
                                           %edge.
                c = c + 1;
                E(1,c) = Boundary(r,2);    %Write in to which edge we belong
            end
        end
    end
    
    %\int_partial varphi_i*N dsigma = \int_{Edge1+Edge2}varphi_i*Ndsigma
    %Interpolate varphi_i as a quadratic spline on first edge E(1,1)
    %%%%%%% Handle 1st Edge contribution ie E(1,1) not  E(1,2) %%%%%%%%%%%
    if Nodal(i,1) == Edge(E(1,1),1) %Extract the Line for E(1,1)
                                    %Means line as given by Edge orients it so our Nodal is first. 
                                    %Both take values in the vertex index
                                    %list. We'll build the line so that
                                    %first entry is our node. Also in
                                    %Loc_P1 Loc_P2 and Loc_Mid we store to
                                    %which indexes in Nodal these points on segment
                                    %correspond.
       Line_Point_1 = vert(Edge(E(1,1),1),:); %xy coordinates are Node
       Line_Point_2 = vert(Edge(E(1,1),2),:);
       Line = [Line_Point_1;Line_Point_2]; %Line extracted.  
       %Locate (Line(1,:),Mid,Line(2,:)) in Nodal
       Loc_P1 = 0;
       Loc_Mid = 0;
       Loc_P2 = 0;
       cycle = 1;
       while Loc_P1 == 0 || Loc_P2 == 0 %These are both genuine verts of triangulation so in Nodal_Bud(2,1)+1:Nodal_Bud(3,1)
           if Edge(E(1,1),1) == Nodal(Nodal_Bud(2,1)+cycle,1) %Scan through Nodal which in this region indexed by vert and find entry in Nodal storing
                                                              %this vertex index. 
               Loc_P1 = Nodal_Bud(2,1)+cycle; %********
           elseif Edge(E(1,1),2) == Nodal(Nodal_Bud(2,1)+cycle,1) %"
               Loc_P2 = Nodal_Bud(2,1)+cycle; %********
           end
           cycle = cycle + 1; 
       end
       cycle = 1;
       while Loc_Mid == 0   %Scan for the midpoint of boundary edge in Nodal, lies in Nodal_Bud(3,1)+1:Nodal_Bud(4,1)
           if E(1,1) == Nodal(Nodal_Bud(3,1)+cycle,1) %In nodal the midpoint nodal is indexed by edge to which belongs
               Loc_Mid = Nodal_Bud(3,1)+cycle; %********
           end
           cycle = cycle + 1;
       end
       
    else %Our node is listed second in this listing. ie Nodal = Edge(E(1,1),2)
        Line_Point_1 = vert(Edge(E(1,1),2),:); %Extract the 2nd entry of edge as is our node
        Line_Point_2 = vert(Edge(E(1,1),1),:);
        Line = [Line_Point_1;Line_Point_2];%Line extracted
       %Locate (Line(1,:),Mid,Line(2,:)) in Nodal
       Loc_P1 = 0;
       Loc_Mid = 0;
       Loc_P2 = 0;
       cycle = 1;
       while Loc_P1 == 0 || Loc_P2 == 0 %These are both genuine verts of triangulation so in Nodal_Bud(2,1)+1:Nodal_Bud(3,1)
           if Edge(E(1,1),2) == Nodal(Nodal_Bud(2,1)+cycle,1) %Scan through Nodal which in this region indexed by vert and find entry in Nodal storing
                                                              %this vertex index. 
               Loc_P1 = Nodal_Bud(2,1)+cycle; %*******
           elseif Edge(E(1,1),1) == Nodal(Nodal_Bud(2,1)+cycle,1) %"
               Loc_P2 = Nodal_Bud(2,1)+cycle; %**********
           end
           cycle = cycle + 1; %*********
       end
       cycle = 1;
       while Loc_Mid == 0   %Scan for the midpoint of boundary edge in Nodal, lies in Nodal_Bud(3,1)+1:Nodal_Bud(4,1)
           if E(1,1) == Nodal(Nodal_Bud(3,1)+cycle,1) %In nodal the midpoint nodal is indexed by edge to which belongs
               Loc_Mid = Nodal_Bud(3,1)+cycle;
           end
           cycle = cycle + 1;
       end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Extract representation of varphi_i on std element as imaged under
    %Std_to_Line
    [dud, J] = Std_to_Line(Line,[0]);
    Qoints = [0 .5 1]';
    Aterp = [zeros(3,1)+1, Qoints, Qoints.^2];
    varphi_coeffs = Aterp\[1 0 0]'; %Aterp *P_coeff = P_val(@Qoints) coefficients ordered on {1,x,x^2} basis.
    varphi_coeffs = varphi_coeffs'; %Make a row vector
    Ndata_coeffs  = Aterp\[Ndata(Loc_P1,1),Ndata(Loc_Mid,1),Ndata(Loc_P2,1)]'; 
    Ndata_coeffs  = Ndata_coeffs'; %Make row vector
    Eval_varphi = varphi_coeffs(1,1)*(zeros(5,1)+1) + varphi_coeffs(1,2)*Points + varphi_coeffs(1,3)*(Points.^2);
    Eval_N = Ndata_coeffs(1,1)*(zeros(5,1)+1) + Ndata_coeffs(1,2)*Points + Ndata_coeffs(1,3)*(Points.^2);
    
    Nval(i,1) = Nval(i,1) + J*(W'*(Eval_varphi.*Eval_N)); %Integrate \int_{E_1}\varphi_i*Nd\sigma = \int^1_0 \varphi\circ*N\circ J dx 
    
    %%%%%%% Handle 2nd Edge contribution ie E(1,2) not  E(1,1) %%%%%%%%%%%
    if Nodal(i,1) == Edge(E(1,2),1) %Extract the Line for E(1,1)
                                    %Means line as given by Edge orients it so our Nodal is first. 
                                    %Both take values in the vertex index
                                    %list. We'll build the line so that
                                    %first entry is our node. Also in
                                    %Loc_P1 Loc_P2 and Loc_Mid we store to
                                    %which indexes in Nodal these points on segment
                                    %correspond.
       Line_Point_1 = vert(Edge(E(1,2),1),:); %xy coordinates are Node
       Line_Point_2 = vert(Edge(E(1,2),2),:);
       Line = [Line_Point_1;Line_Point_2]; %Line extracted.  
       %Locate (Line(1,:),Mid,Line(2,:)) in Nodal
       Loc_P1 = 0;
       Loc_Mid = 0;
       Loc_P2 = 0;
       cycle = 1;
       while Loc_P1 == 0 || Loc_P2 == 0 %These are both genuine verts of triangulation so in Nodal_Bud(2,1)+1:Nodal_Bud(3,1)
           if Edge(E(1,2),1) == Nodal(Nodal_Bud(2,1)+cycle,1) %Scan through Nodal which in this region indexed by vert and find entry in Nodal storing
                                                              %this vertex index. 
               Loc_P1 = Nodal_Bud(2,1)+cycle;
           elseif Edge(E(1,2),2) == Nodal(Nodal_Bud(2,1)+cycle,1) %"
               Loc_P2 = Nodal_Bud(2,1)+cycle;
           end
           cycle = cycle + 1;
       end
       cycle = 1;
       while Loc_Mid == 0   %Scan for the midpoint of boundary edge in Nodal, lies in Nodal_Bud(3,1)+1:Nodal_Bud(4,1)
           if E(1,2) == Nodal(Nodal_Bud(3,1)+cycle,1) %In nodal the midpoint nodal is indexed by edge to which belongs
               Loc_Mid = Nodal_Bud(3,1)+cycle;
           end
           cycle = cycle + 1;
       end
       
    else %Our node is listed second in this listing. ie Nodal = Edge(E(1,1),2)
        Line_Point_1 = vert(Edge(E(1,2),2),:); %Extract the 2nd entry of edge as is our node
        Line_Point_2 = vert(Edge(E(1,2),1),:);
        Line = [Line_Point_1;Line_Point_2];%Line extracted
       %Locate (Line(1,:),Mid,Line(2,:)) in Nodal
       Loc_P1 = 0;
       Loc_Mid = 0;
       Loc_P2 = 0;
       cycle = 1;
       while Loc_P1 == 0 || Loc_P2 == 0 %These are both genuine verts of triangulation so in Nodal_Bud(2,1)+1:Nodal_Bud(3,1)
           if Edge(E(1,2),2) == Nodal(Nodal_Bud(2,1)+cycle,1) %Scan through Nodal which in this region indexed by vert and find entry in Nodal storing
                                                              %this vertex index. 
               Loc_P1 = Nodal_Bud(2,1)+cycle;
           elseif Edge(E(1,2),1) == Nodal(Nodal_Bud(2,1)+cycle,1) %"
               Loc_P2 = Nodal_Bud(2,1)+cycle;
           end
           cycle = cycle + 1;
       end
       cycle = 1;
       while Loc_Mid == 0   %Scan for the midpoint of boundary edge in Nodal, lies in Nodal_Bud(3,1)+1:Nodal_Bud(4,1)
           if E(1,2) == Nodal(Nodal_Bud(3,1)+cycle,1) %In nodal the midpoint nodal is indexed by edge to which belongs
               Loc_Mid = Nodal_Bud(3,1)+cycle;
           end
           cycle = cycle + 1;
       end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Extract representation of varphi_i on std element as imaged under
    %Std_to_Line
    [dud, J] = Std_to_Line(Line,[0]);
    Qoints = [0 .5 1]';
    Aterp = [zeros(3,1)+1, Qoints, Qoints.^2];
    varphi_coeffs = Aterp\[1 0 0]'; %Aterp *P_coeff = P_val(@Qoints) coefficients ordered on {1,x,x^2} basis.
    varphi_coeffs = varphi_coeffs'; %Make a row vector
    Ndata_coeffs  = Aterp\[Ndata(Loc_P1,1),Ndata(Loc_Mid,1),Ndata(Loc_P2,1)]'; 
    Ndata_coeffs  = Ndata_coeffs'; %Make a row vector
    Eval_varphi = varphi_coeffs(1,1)*(zeros(5,1)+1) + varphi_coeffs(1,2)*Points + varphi_coeffs(1,3)*(Points.^2);
    Eval_N = Ndata_coeffs(1,1)*(zeros(5,1)+1) + Ndata_coeffs(1,2)*Points + Ndata_coeffs(1,3)*(Points.^2);
    
    Nval(i,1) = Nval(i,1) + J*(W'*(Eval_varphi.*Eval_N)); %Integrate \int_{E_2}\varphi_i*Nd\sigma = \int^1_0 \varphi\circ*N\circ J dx and add into preexisting.
end



%For nodals on midpoint, the reference call is easy.  Nodal(i,1) in
%Nodal_Bud(3,1)+1:Nodal_Bud(4,1) stores the edge index for which we're
%midpoint. Still must write this range!

for i=Nodal_Bud(3,1)+1:Nodal_Bud(4,1) %Nodal(i,1) is the edge index
    Line = zeros(2,2);
    Line(1,:) = vert(Edge(Nodal(i,1),1),:); %Get vertex indices via Edge and coordinates by vert
    Line(2,:) = vert(Edge(Nodal(i,1),2),:);
    
    %Locate where the edge ends and mids are in Nodal for purpose of
    %recalling Ndata's values there
    Loc_P1 = 0;
    Loc_Mid = i; %We know this mid matches our nodal(i,1) is the midpoint of edge
    Loc_P2 = 0;
    cycle = 1;
    while Loc_P1 == 0 || Loc_P2 == 0 %Edge ends will be genuine verts in triangulation
                                     %and so lie in  Nodal_Bud(2,1)+1:N_B(3,1)
          if Edge(Nodal(i,1),1) == Nodal(Nodal_Bud(2,1)+cycle,1)
              Loc_P1 = Nodal_Bud(2,1)+cycle;
          elseif Edge(Nodal(i,1),2) == Nodal(Nodal_Bud(2,1)+cycle,1)
              Loc_P2 = Nodal_Bud(2,1)+cycle;
          end
          cycle = cycle + 1;
    end
    [dud, J] = Std_to_Line(Line,[0]);
    Qoints = [0 .5 1]';
    Aterp = [zeros(3,1) + 1, Qoints, Qoints.^2];
    varphi_coeffs = Aterp\[0 1 0]'; %This time our basis function is 1 on the midpoint
                                    %Again Aterp*P_coeffs = P_val(@Qoints)
                                    %ordered on {1,x,x^2} basis.
    varphi_coeffs = varphi_coeffs'; %Make a row vector
    Ndata_coeffs  = Aterp\[Ndata(Loc_P1,1), Ndata(Loc_Mid,1), Ndata(Loc_P2,1)]';
    Ndata_coeffs  = Ndata_coeffs';  %Make a row vector
    Eval_varphi = varphi_coeffs(1,1)*(zeros(5,1)+1) + varphi_coeffs(1,2)*Points + varphi_coeffs(1,3)*(Points.^2);
    Eval_N = Ndata_coeffs(1,1)*(zeros(5,1)+1) + Ndata_coeffs(1,2)*Points + Ndata_coeffs(1,3)*(Points.^2);
    
    Nval(i,1) = Nval(i,1) + J*(W'*(Eval_varphi.*Eval_N)); %Integrate \int_E \varphi*Nd\sigma = \int^1_0 \varphi\circ*N\circ Jdx
end

%Now assembled the full Nval matrix at time tsample.  Indeed for any nodal basis element
%with node NOT on the boundary, we know its three coefficients on the
%boundary edge vanish.  But 2d C0 splines when restricted to an edge become
%1d splines of same degree.  Hence these interior nodals vanish identically
%on the boundary.


end

